import React, { FC, useEffect, useRef, useMemo } from "react";
import cx from "classnames";
import { createPopper } from "@popperjs/core";
import LegoPopup from "../lego2/Popup";
import { sameWidthPopperModifier } from "../sameWidthPopperModifier";
import { PopupProps } from "./Popup.types";
import css from "./Popup.module.css";
import { offsetModifier } from "./Popup.config";

export const Popup: FC<PopupProps> = (props) => {
    const {
        isVisible,
        className,
        anchor,
        popperRef,
        direction = "bottom",
        children,
        onClose,
        scope = "inplace",
        sameWidthProperty = "width",
    } = props;

    const popupRef = useRef<HTMLDivElement>(null);

    useEffect(() => {
        if (!anchor || !isVisible) {
            return;
        }

        const popper = createPopper(anchor, popupRef.current!, {
            strategy: "fixed",
            placement: direction,
            modifiers: [
                sameWidthPopperModifier({
                    property: sameWidthProperty,
                }),
                offsetModifier,
            ],
        });

        if (popperRef) {
            popperRef(popper);
        }

        return () => {
            popper.destroy();
        };
    }, [anchor, isVisible]);

    const essentialRefs = useMemo(() => [{ current: anchor }], [anchor]);

    return (
        <LegoPopup
            innerRef={popupRef}
            className={cx(css.Popup, className)}
            scope={scope}
            unstable_essentialRefs={essentialRefs}
            view="default"
            visible={isVisible}
            onClose={onClose}
        >
            {children}
        </LegoPopup>
    );
};
