import React, { FC, memo } from "react";
import Menu from "../lego2/Menu";
import { Text } from "../lego2/Text";
import { LoadingPopup } from "../LoadingPopup";
import { PopupMenuProps } from "./PopupMenu.types";
import css from "./PopupMenu.module.css";
import { useValueKeyboardEvent } from "./useValueKeyboardEvent";

export const PopupMenu: FC<PopupMenuProps> = memo((props) => {
    const {
        anchor,
        isVisible,
        items,
        isFocused,
        onChange,
        isLoading,
        popperRef,
        onClose,
        onEvent,
    } = props;

    useValueKeyboardEvent(isFocused, onEvent);

    const handleChange = (_, value) => {
        if (onChange && value !== "") {
            onChange(value);
        }
    };

    return (
        <LoadingPopup
            isLoading={isLoading}
            anchor={anchor}
            isVisible={isVisible}
            popperRef={popperRef}
            onClose={onClose}
        >
            {!items?.length && (
                <Text
                    className={css.PopupMenu__notFoundText}
                    color="secondary"
                    typography="control-m"
                >
                    Не найдено
                </Text>
            )}
            {Boolean(items?.length) && (
                <Menu
                    className={css.PopupMenu__menu}
                    width="max"
                    items={items}
                    onChange={handleChange}
                    focused={isFocused}
                />
            )}
        </LoadingPopup>
    );
});
