import { useRef, useCallback } from "react";
import { useKeyboard } from "../useKeyboard";
import { valueKeyboardEvent } from "../events";
import { Event } from "../types/Event";

export const useValueKeyboardEvent = (
    isFocused?: boolean,
    onEvent?: (event: Event) => void
) => {
    const wasEventSentRef = useRef(false);

    const emitValueKeyboardEvent = useCallback(() => {
        if (wasEventSentRef.current) {
            return;
        }

        onEvent?.(valueKeyboardEvent());
        wasEventSentRef.current = true;
    }, [onEvent]);

    useKeyboard(
        {
            onDown: emitValueKeyboardEvent,
            onUp: emitValueKeyboardEvent,
        },
        isFocused,
        [emitValueKeyboardEvent]
    );
};
