import * as React from 'react';
import Resizable, { ResizableProps } from 're-resizable';
import cx from 'classnames';
import css from './Resizable.module.css';
import createZIndexStyles from './createZIndexStyles';

export { Resizable as ResizableBase };

const MAP_ENABLE = {
  right: {
    top: false,
    right: true,
    bottom: false,
    left: false,
    topRight: false,
    bottomRight: false,
    bottomLeft: false,
    topLeft: false,
  },
  left: {
    top: false,
    right: false,
    bottom: false,
    left: true,
    topRight: false,
    bottomRight: false,
    bottomLeft: false,
    topLeft: false,
  },
  none: {
    top: false,
    right: false,
    bottom: false,
    left: false,
    topRight: false,
    bottomRight: false,
    bottomLeft: false,
    topLeft: false,
  },
};

interface Props extends ResizableProps {
  enable: any;
  className?: string;
  wrap?: boolean;
  hidden?: boolean;
  handleZIndex?: number;
}

const ResizableExtends = React.forwardRef<Resizable, Props>((props: Props, ref) => {
  const { enable, className, wrap, handleZIndex, hidden, ...rest } = props;

  let patchedEnable = enable;
  if (typeof enable === 'string') {
    patchedEnable = MAP_ENABLE[enable];
  }

  const classNameExtended = cx(className, { [css.b_wrap]: wrap, [css.b_hidden]: hidden });

  return React.createElement(Resizable, {
    enable: patchedEnable,
    className: classNameExtended,
    handleStyles: createZIndexStyles(handleZIndex),
    ref,
    ...rest,
  });
});

ResizableExtends.defaultProps = {
  className: '',
  wrap: false,
  handleZIndex: 10,
};

export default ResizableExtends;
