/*
eslint-disable no-param-reassign
*/

import memoize from "lodash/memoize";

const DIRECTIONS = [
    "top",
    "right",
    "bottom",
    "left",
    "topRight",
    "bottomRight",
    "bottomLeft",
    "topLeft",
];

const createZIndexStyles = (zIndex) => {
    const style = { zIndex };
    return DIRECTIONS.reduce((ac, direction) => {
        ac[direction] = style;
        return ac;
    }, {});
};

export default memoize(createZIndexStyles);
