import React from "react";
import Modal from "../lego2/Modal";
import Button from "../lego2/Button";
import { Scrollable } from "./Scrollable";

export default {
    title: "Scrollable",
    component: Scrollable,
};

const renderList = Array(50)
    .fill(0)
    .map((_, id) => <div key={id}>{id}</div>);

export const scrollable = (args) => (
    <div style={{ height: 300 }}>
        <Scrollable {...args}>{renderList}</Scrollable>
    </div>
);

export const scrollableModal = (args) => (
    <Modal
        size="mid"
        visible
        title="Scrollable"
        onClose={() => {}}
        footerRightChildren={<Button>Close</Button>}
        {...args}
    >
        {renderList}
    </Modal>
);
scrollableModal.args = {
    scrollableContent: true,
};
