import { ScrollDirection } from './Scrollable.types';

interface getScrollDirectionProps {
  scrollTop: number;
  scrollHeight: number;
  clientHeight: number;
}

export const getScrollDirection = ({
  scrollTop,
  scrollHeight,
  clientHeight,
}: getScrollDirectionProps) => {
  const top = Math.ceil(scrollTop);
  const maxScrollTop = Math.ceil(scrollHeight - clientHeight);

  let scrollDirection: ScrollDirection = 'both';
  if (maxScrollTop <= 0) scrollDirection = 'none';
  else if (top <= 0) scrollDirection = 'bottom';
  else if (top >= maxScrollTop) scrollDirection = 'top';

  return scrollDirection;
};
