import React from "react";
import { storiesOf } from "@storybook/react";
import Icon from "../Icon";
import Button from "./Button";

storiesOf("Lego", module).add("Button", () => (
    <div>
        <div>
            <Button>button</Button>
        </div>
        <div>
            <Button
                size="xs"
                iconLeft={(className) => (
                    <Icon className={className} type="close" />
                )}
                iconRight={(className) => (
                    <Icon className={className} type="close" />
                )}
            >
                button
            </Button>
        </div>
        <div>
            <Button
                direction={Button.Direction.Vertical}
                size="xs"
                iconLeft={(className) => (
                    <Icon className={className} type="close" />
                )}
                iconRight={(className) => (
                    <Icon className={className} type="close" />
                )}
            >
                button
            </Button>
        </div>
        <div>
            <Button
                direction={Button.Direction.Vertical}
                size="s"
                iconLeft={(className) => (
                    <Icon className={className} type="close" />
                )}
            >
                button
            </Button>
        </div>
        <div>
            <Button
                direction={Button.Direction.Vertical}
                size="m"
                iconLeft={(className) => (
                    <Icon className={className} type="close" />
                )}
            >
                button
            </Button>
        </div>
        <div>
            <Button
                direction={Button.Direction.Vertical}
                size="l"
                iconLeft={(className) => (
                    <Icon className={className} type="close" />
                )}
            >
                button
            </Button>
        </div>
    </div>
));
