import * as React from 'react';
import { compose } from '@bem-react/core';
import { Checkbox, ICheckboxProps } from '@yandex-lego/components/Checkbox/desktop/bundle';
import { withLineHeightSizeXS } from './_lineHeightSize/Checkbox_lineHeightSize_xs';
import { withLineHeightSizeS } from './_lineHeightSize/Checkbox_lineHeightSize_s';
import { withLineHeightSizeM } from './_lineHeightSize/Checkbox_lineHeightSize_m';
import { withLineHeightSizeL } from './_lineHeightSize/Checkbox_lineHeightSize_l';
import './Checkbox.css';

interface CheckboxProps extends Omit<ICheckboxProps, 'onChange' | 'label'> {
  lineHeightSize?: 'xs' | 's' | 'm' | 'l';
  label?: React.ReactNode;
  isEventValue?: boolean;
  onChange?: (value: React.ChangeEvent<HTMLInputElement> | boolean) => void;
  children?: React.ReactNode;
}

interface SizeMapper {
  [key: string]: 's' | 'm';
}
const SIZE_MAPPER: SizeMapper = {
  xs: 's',
  s: 's',
  m: 'm',
  l: 'm',
};

const ComposedCheckbox = compose(
  withLineHeightSizeXS,
  withLineHeightSizeS,
  withLineHeightSizeM,
  withLineHeightSizeL,
)(Checkbox) as React.FC<CheckboxProps>;

class CheckboxWrap extends React.Component<CheckboxProps> {
  public static defaultProps = {
    lines: 'multi',
    view: 'default',
    isEventValue: false,
    size: 's',
  };

  private handleChange = (event: React.ChangeEvent<HTMLInputElement>): void => {
    const { onChange, isEventValue } = this.props;
    if (typeof onChange === 'function') {
      if (isEventValue) {
        onChange(event);
      } else {
        onChange(event.target.checked);
      }
    }
  };

  private mapChildrenToLabel = (
    children: React.ReactNode,
    label: React.ReactNode,
  ): React.ReactNode => {
    if (label) {
      return label;
    }

    return children;
  };

  public render(): React.ReactNode {
    const {
      lineHeightSize,
      size = 's',
      label,
      children,
      checked,
      // https://st.yandex-team.ru/CRM-15295
      isEventValue,
      onFocusChange,
      hasClear,
      extraProps,
      ...other
      // eslint-disable-next-line
    } = this.props as any;

    return (
      <ComposedCheckbox
        {...other}
        checked={Boolean(checked)}
        label={this.mapChildrenToLabel(children, label) as string}
        size={SIZE_MAPPER[size]}
        onChange={this.handleChange}
      />
    );
  }
}

export default CheckboxWrap;
