import React, { FC, useState, useCallback, useRef, RefObject } from "react";
import Button from "../Button";
import Popup from "../Popup/Popup";
import Icon from "../Icon";
import { DropdownProps } from "./Dropdown.types";

const Dropdown: FC<DropdownProps> = (props) => {
    const {
        content,
        buttonClassName,
        hasArrow = false,
        popupDirections,
    } = props;

    const [visible, setVisible] = useState(false);
    const buttonRef = useRef() as RefObject<HTMLButtonElement>;
    const hide = useCallback(() => {
        setVisible(false);
    }, [setVisible]);
    const handleButtonClick = useCallback(() => {
        setVisible(!visible);
    }, [setVisible, visible]);

    const arrowIconProvider = (cls) => (
        <Icon
            className={cls}
            type="arrow"
            direction={visible ? "top" : "bottom"}
        />
    );

    return (
        <>
            <Button
                innerRef={buttonRef}
                onClick={handleButtonClick}
                view={props.view}
                className={buttonClassName}
                iconRight={hasArrow ? arrowIconProvider : undefined}
                iconLeft={props.iconLeft}
            >
                {props.children}
            </Button>
            <Popup
                visible={visible}
                view="default"
                target="anchor"
                anchor={buttonRef}
                directions={popupDirections}
                onOutsideClick={hide}
            >
                {content}
            </Popup>
        </>
    );
};

export default Dropdown;
