import React from "react";
import { storiesOf } from "@storybook/react";
import Button from "lego2/Button";
import Icon from "./Icon";

const storiesBlock = storiesOf("Lego2", module);

storiesBlock.add("Icon", () => (
    <div>
        <div>
            <Button
                view="action"
                size="s"
                icon={(cls) => (
                    <Icon className={cls} glyph="type-cross" size="l" />
                )}
            />
            <Button
                view="action"
                size="m"
                icon={(cls) => (
                    <Icon className={cls} glyph="type-cross" size="l" />
                )}
            />
            <Button
                view="action"
                size="l"
                icon={(cls) => (
                    <Icon className={cls} glyph="type-cross" size="l" />
                )}
            />
        </div>
        <div>
            <Button
                view="action"
                size="s"
                icon={(cls) => <Icon svg="filter" className={cls} />}
            />
            <Button
                view="action"
                size="m"
                icon={(cls) => <Icon svg="filter" className={cls} />}
            />
            <Button
                view="action"
                size="l"
                icon={(cls) => <Icon svg="filter" className={cls} />}
            />
        </div>
        <div>
            <Button
                view="action"
                size="s"
                icon={(cls) => <Icon svg="filter" className={cls} />}
            />
            <Button
                view="action"
                size="m"
                icon={(cls) => <Icon svg="filter" className={cls} />}
            />
            <Button
                view="action"
                size="l"
                icon={(cls) => <Icon svg="filter" className={cls} />}
            />
        </div>
        <div>
            <Button
                view="action"
                size="s"
                icon={(cls) => <Icon svg="check" className={cls} />}
            />
        </div>
        <div>
            <Button
                view="action"
                size="s"
                icon={(cls) => <Icon svg="empty" className={cls} />}
            />
        </div>
    </div>
));
