import { Icon } from '@yandex-lego/components/Icon/desktop/bundle';
import * as React from 'react';
import cx from 'classnames';
import IconSvg from './IconSvg';
import css from './Icon.module.css';
import { IconExtendProps, SvgSize } from './Icon.types';

const svgSizeMap: Record<SvgSize, number> = {
  xxxl: 80,
  xxl: 56,
  xl: 32,
  l: 24,
  ml: 16,
  m: 14,
  ms: 12,
  s: 10,
};

const IconExtend: React.FC<IconExtendProps> = (props) => {
  let formattedProps = props;

  if (formattedProps.svg) {
    const svgSize = formattedProps.svgSize || 'm';
    const svgUseSelfWidth = formattedProps.svgUseSelfWidth;

    const svgSizePixel = svgSizeMap[svgSize];

    formattedProps = {
      ...formattedProps,
      children: <IconSvg icon={formattedProps.svg} width={svgSizePixel} height={svgSizePixel} />,
      className: cx(
        'Icon_hasGlyph',
        svgUseSelfWidth ? css[`Icon_size_${svgSize}`] : undefined,
        formattedProps.className,
      ),
    };

    delete formattedProps.svg;
    delete formattedProps.svgSize;
    delete formattedProps.svgUseSelfWidth;
  }

  return <Icon {...formattedProps} />;
};

IconExtend.defaultProps = {
  size: 's',
};

export default IconExtend;
