import React, { SVGAttributes } from 'react';
import svgIcons, { SvgIconType as _SvgIconType } from './svg';

interface Props extends SVGAttributes<HTMLOrSVGElement> {
  icon: _SvgIconType;
}

const IconSvg: React.FC<Props> = (props) => {
  const { icon, ...other } = props;

  const Component = svgIcons[icon];

  if (!Component) {
    return null;
  }

  return <Component {...other} />;
};

export type SvgIconType = _SvgIconType;

export default IconSvg;
