import * as React from 'react';
import { Link as LegoLink, ILinkProps } from '@yandex-lego/components/Link/desktop/bundle';
import { compose } from '@bem-react/core';
import { withThemeSecondary } from './_theme/Link_theme_secondary';

type LinkTheme = 'black' | 'ghost' | 'normal' | 'outer' | 'pseudo' | 'strong' | 'secondary';
interface LinkProps extends ILinkProps {
  theme?: LinkTheme;
}

const CastedLink = LegoLink as React.FC<LinkProps>;
const Link: React.FC<LinkProps> = (props) => {
  // https://st.yandex-team.ru/CRM-15295
  // eslint-disable-next-line
  const { theme = 'normal', navigate, ...restProps } = props as any;
  return <CastedLink theme={theme} {...restProps} />;
};

const ComposedLink = compose(withThemeSecondary)(Link) as React.FC<LinkProps>;

export default ComposedLink;
