/* eslint-disable @typescript-eslint/no-explicit-any */

import { Menu, IMenuProps } from '@yandex-lego/components/Menu/desktop/bundle';
import * as React from 'react';
import { compose } from '@bem-react/core';
import { withSizeXS } from './_size/Menu_size_xs';
import './Menu_theme_mg.css';

export interface MenuWrapProps extends Omit<IMenuProps, 'size' | 'onChange'> {
  onChange?: (event: { target: { value: any } }, value?: any) => void;
  /** @deprecated use onChange */
  onClick?: (event: { target: { value: any } }, value?: any) => void;
  size?: IMenuProps['size'] | 'xs';
}

const MenuWithCustomMod = compose(withSizeXS)(Menu) as React.FC<MenuWrapProps>;

const MenuWrap: React.FC<MenuWrapProps> = (props) => {
  const { size = 's', view = 'default', onClick, onChange, ...rest } = props;

  const handleChange = (event) => {
    onClick?.(event, event.target.value);
    onChange?.(event, event.target.value);
  };

  return <MenuWithCustomMod size={size} view={view} {...rest} onChange={handleChange} />;
};

export default MenuWrap;
