import React, { useEffect, ReactNode } from 'react';
import { compose as bemCompose } from '@bem-react/core';
import { withProps, compose } from 'recompose';
import { Modal, IModalProps } from '@yandex-lego/components/Modal/desktop/bundle';
import { withZIndex } from '@yandex-lego/components/withZIndex';
import {
  withSizeAuto,
  withSizeSmall,
  withSizeMid,
  withSizeLarge,
  withSizeFull,
  withSizeFixHeight,
} from './_size';
import { withLimitHeight } from './_limitHeight';
import { ModalSize } from './_size/types';
import ModalContent from './ModalContent';
import './Modal.css';

export interface ModalProps extends IModalProps {
  theme?: 'normal';
  size?: ModalSize;
  title?: string;
  paddingTop?: boolean;
  contentClassName?: string;
  onMinimize?: () => void;
  onExited?: () => void;
  footerComponent?: (cn: string, rightChildren: ReactNode, leftChildren: ReactNode) => ReactNode;
  footerLeftChildren?: ReactNode;
  footerRightChildren?: ReactNode;
  scrollableContent?: boolean;
  limitHeight?: boolean;
}

const ComposedModal = bemCompose(
  withSizeAuto,
  withSizeSmall,
  withSizeMid,
  withSizeLarge,
  withSizeFull,
  withSizeFixHeight,
  withLimitHeight,
)(Modal) as React.FC<ModalProps>;

const ModalWrap: React.FC<ModalProps> = (props) => {
  const {
    title,
    children,
    paddingTop,
    theme = 'normal',
    zIndex = 1000,
    contentClassName,
    // https://st.yandex-team.ru/CRM-15295
    onClose,
    subModalsCount,
    isMinimized,
    onMinimize,
    onExited,
    footerComponent,
    footerLeftChildren,
    footerRightChildren,
    scrollableContent,
    limitHeight,
    ...restProps
    // eslint-disable-next-line
  } = props as any;

  useEffect(() => {
    return onExited;
  }, []);

  return (
    <ComposedModal
      data-testid="Modal"
      trapFocus={false}
      preventBodyScroll={false}
      theme={theme}
      zIndex={zIndex}
      keepMounted={false}
      limitHeight={limitHeight || scrollableContent}
      {...restProps}
    >
      <ModalContent
        title={title}
        onMinimize={onMinimize}
        onClose={onClose as () => void}
        paddingTop={paddingTop}
        className={contentClassName}
        footerComponent={footerComponent}
        footerLeftChildren={footerLeftChildren}
        footerRightChildren={footerRightChildren}
        scrollableContent={scrollableContent}
      >
        {children}
      </ModalContent>
    </ComposedModal>
  );
};

export default compose(
  withProps((props) => ({
    visible: props.visible,
  })),
  withZIndex,
)(ModalWrap);
