import { Direction as NewDirection } from '@yandex-lego/components/usePopper';
import Popup from './Popup';
import ImperativePopup, {
  ImperativePopupProps as ImpPopupProps,
  ElementAsRenderProp as ElAsRenderProps,
} from './ImperativePopup';
import StatefulPopup from './StatefulPopup';

type OldDirection =
  | 'top-center'
  | 'top-left'
  | 'top-right'
  | 'bottom-left'
  | 'bottom-right'
  | 'bottom-center'
  | 'right-top'
  | 'right-bottom'
  | 'right-center'
  | 'left-top'
  | 'left-bottom'
  | 'left-center';

export type ImperativePopupProps = ImpPopupProps;
export type ElementAsRenderProp = ElAsRenderProps;
export type Direction = OldDirection | NewDirection;
export { ImperativePopup, StatefulPopup };
export default Popup;
