import * as React from 'react';
import {
  withOutsideClick as legoWithOutsideClick,
  IWithOutsideClickProps,
  IWrappedComponentProps,
} from '@yandex-lego/components/withOutsideClick';

export type WithOutsideClickProps = IWithOutsideClickProps;

interface WrappedComponentProps extends IWrappedComponentProps {
  ignoreRefs?: React.RefObject<HTMLElement>[];
  anchor?: React.RefObject<HTMLElement>;
  target?: 'anchor';
}

const withAnchorIgnore = <TProps extends WrappedComponentProps>(
  WrappedComponent: React.ComponentType<TProps>,
): React.ComponentType<TProps & WithOutsideClickProps> => {
  return (props) => {
    const modifiedProps: TProps = { ...props };
    if (props.target === 'anchor' && props.anchor) {
      modifiedProps.ignoreRefs = [props.anchor];
    }

    return <WrappedComponent {...modifiedProps} />;
  };
};

export const withOutsideClick = (component) => {
  return withAnchorIgnore(legoWithOutsideClick(component));
};
