import * as React from 'react';

interface Props {
  stopPropagation?: boolean;
}

const handleClick = (event: React.MouseEvent) => {
  event.stopPropagation();
};

export const withStopPropagation = <TProps extends React.PropsWithChildren<{}>>(
  WrappedComponent: React.ComponentType<TProps>,
) => {
  return (props: Props & TProps) => {
    const { stopPropagation, ...propsCopy } = props;
    const forwardProps = propsCopy as TProps;
    forwardProps.children = (
      <span
        role="presentation"
        style={{ display: 'contents' }}
        onClick={stopPropagation ? handleClick : undefined}
      >
        {forwardProps.children}
      </span>
    );
    return <WrappedComponent {...forwardProps} />;
  };
};
