import * as React from 'react';
import { RadioButton, IRadioButtonProps } from '@yandex-lego/components/RadioButton/desktop/bundle';
import cx from 'classnames';
import './RadioButton.css';

export interface RadioButtonProps extends Omit<IRadioButtonProps, 'onChange'> {
  isEventValue?: boolean;
  onChange?: (value: React.ChangeEvent<HTMLInputElement> | string) => void;
  width?: 'max' | 'auto';
}

class RadioButtonWrap extends React.Component<RadioButtonProps> {
  public static defaultProps = {
    isEventValue: true,
    view: 'default',
    width: 'max',
  };

  private handleChange = (event: React.ChangeEvent<HTMLInputElement>) => {
    if (this.props.onChange) {
      let value: React.ChangeEvent<HTMLInputElement> | string = event;
      if (!this.props.isEventValue) {
        ({ value } = event.target);
      }

      this.props.onChange(value);
    }
  };

  public render(): React.ReactNode {
    const { className, children, width, isEventValue, ...props } = this.props;

    return (
      <RadioButton
        {...props}
        onChange={this.handleChange}
        className={cx(className, `CRMRadioButton_width_${width}`)}
      />
    );
  }
}

export default RadioButtonWrap;
