import * as React from 'react';
import {
  Radiobox,
  Radio,
  RadioboxProps as IRadioboxProps,
} from '@yandex-lego/components/Radiobox/desktop/bundle';
import './Radiobox.css';
import cx from 'classnames';

interface RadioboxProps extends Omit<IRadioboxProps, 'onChange'> {
  onChange?: (value: React.ChangeEvent<HTMLInputElement> | string) => void;
  view?: 'default';
  isEventValue?: boolean;
}

class RadioboxWrap extends React.Component<RadioboxProps> {
  public static defaultProps = {
    size: 's',
    view: 'default',
    isEventValue: true,
  };

  private handleChange = (event: React.ChangeEvent<HTMLInputElement>): void => {
    if (this.props.onChange) {
      let value: React.ChangeEvent<HTMLInputElement> | string = event;
      if (!this.props.isEventValue) {
        ({ value } = event.target);
      }

      this.props.onChange(value);
    }
  };

  public render(): React.ReactNode {
    const { className, children, ...props } = this.props;

    return (
      <Radiobox {...props} className={cx(className, 'CRMRadiobox')} onChange={this.handleChange}>
        {children}
      </Radiobox>
    );
  }
}

export { Radio };
export default RadioboxWrap;
