import React, { PureComponent, ReactNode } from 'react';
import { withBemMod } from '@bem-react/core';
import { cnSelect } from '@yandex-lego/components/Select';
import { SelectProps } from '../Select.types';

export const withMultiple = withBemMod<SelectProps>(
  cnSelect(),
  { multiple: true },
  (Select) =>
    class WithMultiple extends PureComponent<SelectProps> {
      private createValueAsCheckMode = (value: undefined | string | string[]): string[] => {
        if (!value) {
          return [];
        }

        if (Array.isArray(value)) {
          return value;
        }

        return [value];
      };

      public render(): ReactNode {
        const { multiple, value, ...props } = this.props;

        return <Select {...props} value={this.createValueAsCheckMode(value)} />;
      }
    },
);
