import React, { Component, ReactNode } from 'react';
import { withBemMod } from '@bem-react/core';
import { cnSelect } from '@yandex-lego/components/Select';
import { SelectProps, SelectValue } from './Select.types';

export const withFixKeyDown = withBemMod<SelectProps>(
  cnSelect(),
  { fixKeyDown: true },
  (Select) =>
    class FixKeyDown extends Component<SelectProps> {
      // HACK FIX https://st.yandex-team.ru/CRM-10300
      private onKeyDownFix = (event: KeyboardEvent): void => {
        if (event.key === ' ') {
          event.stopImmediatePropagation();
        }
      };

      private subscribeKeyDownFix = () => {
        document.addEventListener('keydown', this.onKeyDownFix, true);
      };

      private unsubcribeKeyDownFix = () => {
        document.removeEventListener('keydown', this.onKeyDownFix, true);
      };

      private handleChange = (event: React.ChangeEvent<HTMLSelectElement> | string): void => {
        const { onChange, hasEmptyValue } = this.props;
        if (!onChange) {
          return;
        }

        let value: SelectValue;
        if (typeof event === 'string') {
          value = event;
        } else {
          ({ value } = event.target);
        }
        if (!hasEmptyValue && value === '') {
          return;
        }

        onChange(event);
      };

      public componentDidUpdate(prevProps: SelectProps) {
        if (!prevProps.opened && this.props.opened) {
          this.subscribeKeyDownFix();
        }
        if (prevProps.opened && !this.props.opened) {
          this.unsubcribeKeyDownFix();
        }
      }

      public componentWillUnmount() {
        this.unsubcribeKeyDownFix();
      }

      public render(): ReactNode {
        return <Select {...this.props} onChange={this.handleChange} />;
      }
    },
);
