import { ITextareaProps } from '@yandex-lego/components/Textarea/desktop/bundle';

export type InnerTextareaProps = Omit<ITextareaProps, 'size'> & {
  size?: 'xs' | 's' | 'm';
  maxHeight?: number;
  cursorPosition: number;
};

interface WithEventValue {
  isEventValue: true;
  onChange?: (event: React.ChangeEvent<HTMLTextAreaElement>) => void;
}

interface WithStringValue {
  isEventValue?: false;
  onChange?: (value: string) => void;
}

export type OuterTextareaProps = Omit<InnerTextareaProps, 'onChange'> &
  (WithStringValue | WithEventValue);

export interface Overflow {
  node: Element;
  scrollTop: number;
}
