import { Overflow } from '../Textarea.types';

export function getParentOverflows(currentElement: Element) {
  const arr: Overflow[] = [];

  while (currentElement.parentNode instanceof Element) {
    if (currentElement.parentNode.scrollTop) {
      arr.push({
        node: currentElement.parentNode,
        scrollTop: currentElement.parentNode.scrollTop,
      });
    }
    currentElement = currentElement.parentNode;
  }

  return arr;
}
