import { ITextinputProps } from '@yandex-lego/components/Textinput/desktop/bundle';
import { LegoSizeProp } from '../types';

export interface TextinputProps extends Omit<ITextinputProps, 'size' | 'onChange' | 'autoFocus'> {
  onKeyUp?: (event: React.KeyboardEvent) => void;
  onChange?: (event: React.ChangeEvent<HTMLSpanElement>) => void;
  autoFocus?: boolean | number;
  width?: 's';
  size?: LegoSizeProp;
}

export interface TextinputWrapProps extends Omit<TextinputProps, 'onChange'> {
  onChange?: (value: string, event: React.ChangeEvent<HTMLInputElement>) => void;
}

export interface TextinputWrapState {
  autoFocus: boolean;
}
