import React, { useRef } from "react";
import {
    ITextinputProps,
    ITextinputHasClearProps,
} from "@yandex-lego/components/Textinput";
import { mergeAllRefs } from "@yandex-lego/components/lib/mergeRefs";
import Icon from "../../Icon";
import css from "./Textinput_hasClear.module.css";

// TODO: https://st.yandex-team.ru/CRM-16283
export const withHasClear =
    <Props extends ITextinputProps>(
        WrappedComponent: React.ComponentType<Props>
    ) =>
    (props: Props & ITextinputHasClearProps) => {
        const {
            controlRef,
            hasClear,
            iconRight,
            onChange,
            onClearClick,
            value,
        } = props;
        const controlClearRef = useRef<HTMLInputElement>(null);

        const handleClear = (event) => {
            if (controlClearRef.current && !event.isDefaultPrevented()) {
                controlClearRef.current.focus();

                if (onChange) {
                    let syntheticEvent = Object.create(event);
                    syntheticEvent.target = controlClearRef.current;
                    syntheticEvent.currentTarget = controlClearRef.current;

                    controlClearRef.current.value = "";
                    onChange(syntheticEvent);
                }
            }
            onClearClick?.(event);
        };

        return (
            <WrappedComponent
                {...props}
                hasClear={false}
                controlRef={mergeAllRefs(controlClearRef, controlRef)}
                iconRight={
                    hasClear && value ? (
                        <Icon
                            className={css.Textinput_hasClear__icon}
                            onClick={handleClear}
                            onMouseDown={(event) => {
                                event.preventDefault();
                            }}
                            svg="cross"
                        />
                    ) : (
                        iconRight
                    )
                }
            />
        );
    };
