import React, { useCallback, FC, MouseEvent } from "react";
import Button from "../../../../Button";
import Icon from "../../../../Icon";
import cx from "classnames";
import { NumberStepProps } from "./NumberStep.types";
import { DEFAULT_STEP } from "./NumberStep.constants";
import "./NumberStep.css";

const NumberStep: FC<NumberStepProps> = (props) => {
    const { onClick, step, className } = props;
    const handleClick = useCallback(
        (event: MouseEvent) => {
            const currentStep = step != null ? step : DEFAULT_STEP;
            if (onClick) {
                onClick(event, currentStep);
            }
        },
        [onClick, step]
    );

    return (
        <div className={cx("NumberStep", className)}>
            <Button
                view="clear"
                onClick={handleClick}
                className="NumberStep-Button"
                icon={(iconCls) => <Icon type="arrow" className={iconCls} />}
            />
        </div>
    );
};

export default NumberStep;
