import React, { PureComponent, createRef, MouseEvent, ReactNode } from "react";
import { withBemMod } from "@bem-react/core";
import { cnTextinput } from "@yandex-lego/components/Textinput";
import { mergeAllRefs } from "@yandex-lego/components/lib/mergeRefs";
import { TextinputProps } from "../../../Textinput/Textinput.types";
import NumberStep from "./NumberStep";
import "./withNumberStep.css";

const incStepClassName = cnTextinput("NumberStep", {
    increment: true,
});
const decStepClassName = cnTextinput("NumberStep", {
    decrement: true,
});
export const withNumberStep = withBemMod<TextinputProps>(
    cnTextinput(),
    { type: "number" },
    (Textinput) =>
        class WithNumberStep extends PureComponent<TextinputProps> {
            private readonly controlRef = createRef<HTMLInputElement>();

            private onStepClick = (event: MouseEvent, step: number): void => {
                if (
                    this.controlRef.current !== null &&
                    !event.isDefaultPrevented()
                ) {
                    this.controlRef.current.focus();

                    if (this.props.onChange == null) {
                        return;
                    }

                    const originalValue = this.controlRef.current.value;

                    // Создаем синтетическое событие для` эмуляции очистки контрола.
                    const syntheticEvent = Object.create(event);
                    syntheticEvent.target = this.controlRef.current;
                    syntheticEvent.currentTarget = this.controlRef.current;

                    let nextValue: number = step;
                    if (originalValue) {
                        nextValue = Number.parseInt(originalValue, 10) + step;
                    }
                    if (Number.isNaN(nextValue)) {
                        nextValue = originalValue as unknown as number;
                    }
                    this.controlRef.current.value = String(nextValue);

                    this.props.onChange(syntheticEvent);
                    // Восстанавливаем предыдущее значение на тот случай,
                    // если в обработчике onChange не было установлено пустое значение.
                    this.controlRef.current.value = originalValue;
                }
            };

            public render(): ReactNode {
                const { addonAfter, ...props } = this.props;

                return (
                    <Textinput
                        {...props}
                        controlRef={mergeAllRefs(
                            this.controlRef,
                            this.props.controlRef
                        )}
                        addonAfter={
                            <>
                                <div className="NumberStepWrap">
                                    <NumberStep
                                        step={+1}
                                        onClick={this.onStepClick}
                                        className={incStepClassName}
                                    />
                                    <NumberStep
                                        step={-1}
                                        onClick={this.onStepClick}
                                        className={decStepClassName}
                                    />
                                </div>
                                {addonAfter}
                            </>
                        }
                    />
                );
            }
        }
);
