import React, { useEffect, useRef, useState } from "react";
import { DIRECTIONS } from "../../Popup/Popup.config";
import Tooltip from "../Tooltip";
import { ToolTipWrapperProps } from "./ToolTipWrapper.types";

export const ToolTipWrapper: React.FC<ToolTipWrapperProps> = ({
    content,
    children,
    containerClassName,
    openDelay = 0,
    closeDelay = 0,
    disabled,
    ...props
}) => {
    const ref = useRef(null);
    const [visible, setVisible] = useState(false);
    const [isMouseEnter, setMouseEnter] = useState(false);

    const handleMouseEnter = () => {
        setMouseEnter(true);
    };

    const handleMouseLeave = () => {
        setMouseEnter(false);
    };

    useEffect(() => {
        if (visible !== isMouseEnter) {
            const timeId = setTimeout(
                () => {
                    setVisible(isMouseEnter);
                },
                isMouseEnter ? openDelay : closeDelay
            );

            return () => {
                clearTimeout(timeId);
            };
        }
    }, [visible, isMouseEnter]);

    return (
        <span
            role="presentation"
            ref={ref}
            onMouseEnter={handleMouseEnter}
            onMouseLeave={handleMouseLeave}
            className={containerClassName}
        >
            {children}
            <Tooltip
                hasTail
                visible={!disabled && visible && Boolean(content)}
                direction={DIRECTIONS}
                anchor={ref}
                keepMounted={false}
                boundary={{ current: document.body }}
                view="default"
                size="s"
                {...props}
            >
                {content}
            </Tooltip>
        </span>
    );
};
