import * as React from "react";
import {
    Tooltip,
    TooltipStateful as _TooltipStateful,
    TooltipProps,
} from "@yandex-lego/components/Tooltip/desktop/bundle";
import {
    TooltipViewDefaultProps,
    TooltipSizeSProps,
} from "@yandex-lego/components/Tooltip/desktop";
import { withZIndex } from "@yandex-lego/components/withZIndex";
import { compose } from "@bem-react/core";
import { withDirections, Direction } from "../withOldDirections";
import { withPaddingXS } from "./_padding/Tooltip_padding_xs";
import { withViewAction } from "./_view/Tooltip_view_action";
import { withViewInverse } from "./_view/Tooltip_view_inverse";

type ITooltipProps = TooltipProps & TooltipViewDefaultProps & TooltipSizeSProps;
export interface ComposedTooltipProps
    extends Omit<ITooltipProps, "view" | "direction"> {
    padding?: "xs";
    view?: "default" | "action" | "inverse";
    direction?: Direction | Direction[];
}

const ComposedTooltip = compose(
    withPaddingXS,
    withViewAction,
    withViewInverse,
    withDirections,
    withZIndex
)(Tooltip) as React.FC<ComposedTooltipProps>;

export const TooltipStateful = withDirections(_TooltipStateful);
export default ComposedTooltip;
