import * as React from 'react';
import { default as ComposedTooltip, ComposedTooltipProps } from '../Tooltip';

interface TooltipPropsWithDelay extends ComposedTooltipProps {
  onDelayEnd: () => void;
  tooltipCloseDelay?: number;
}

export default class TooltipWithDelay extends React.Component<TooltipPropsWithDelay> {
  timerId: number;

  public static defaultProps = {
    tooltipCloseDelay: 1500,
  };

  componentDidUpdate() {
    const { onDelayEnd, visible, tooltipCloseDelay } = this.props;

    if (onDelayEnd && visible) {
      this.timerId = window.setTimeout(() => onDelayEnd(), tooltipCloseDelay);
    }
  }

  componentWillUnmount(): void {
    clearTimeout(this.timerId);
  }

  render() {
    const { onDelayEnd, tooltipCloseDelay, ...otherProps } = this.props;
    return <ComposedTooltip {...otherProps} />;
  }
}
