import React from "react";
import LegoLink, { ILinkThemeSecondaryProps } from "../Link";
import {
    ILinkProps,
    ILinkPseudoProps,
    ILinkThemeBlackProps,
    ILinkThemeGhostProps,
    ILinkThemeNormalProps,
    ILinkThemePseudoProps,
    ILinkThemeStrongProps,
    ILinkThemeOuterProps,
} from "@yandex-lego/components/Link";
import { Link, LinkProps } from "react-router-dom";

type LegoLinkProps = ILinkProps &
    (
        | {}
        | ILinkThemeBlackProps
        | ILinkThemeGhostProps
        | ILinkThemeNormalProps
        | ILinkThemePseudoProps
        | ILinkThemeStrongProps
        | ILinkThemeSecondaryProps
        | ILinkPseudoProps
        | ILinkThemeOuterProps
    );

type Props = LinkProps & LegoLinkProps;

const LegoRouterLink: React.FC<Props> = (props) => (
    <Link component={LegoLink} {...props} />
);

export default LegoRouterLink;
