import React, { ComponentType } from "react";
import { TooltipProps } from "@yandex-lego/components/Tooltip/desktop/bundle";
import {
    IPopupProps,
    Direction as NewDirection,
} from "@yandex-lego/components/Popup/desktop/bundle";
import { DIRECTIONS_MAP as DIRECTIONS_MAP_OLD } from "./Popup/Popup.config";

export type OldDirection =
    | "top-center"
    | "top-left"
    | "top-right"
    | "bottom-left"
    | "bottom-right"
    | "bottom-center"
    | "right-top"
    | "right-bottom"
    | "right-center"
    | "left-top"
    | "left-bottom"
    | "left-center";

export type Direction = NewDirection | OldDirection;

export const NEW_DIRECTIONS: NewDirection[] = [
    "bottom-start",
    "bottom",
    "bottom-end",
    "top-start",
    "top",
    "top-end",
    "right-start",
    "right",
    "right-end",
    "left-start",
    "left",
    "left-end",
];

export const DIRECTIONS_MAP = {
    "bottom-left": "bottom-start",
    "bottom-center": "bottom",
    "bottom-right": "bottom-end",
    "right-center": "right",
    "right-top": "right-start",
    "right-bottom": "right-end",
    "top-left": "top-start",
    "top-center": "top",
    "top-right": "top-end",
    "left-top": "left-start",
    "left-center": "left",
    "left-bottom": "left-end",
    ...NEW_DIRECTIONS.reduce((acc, direction) => {
        acc[direction] = direction;
        return acc;
    }, {}),
};

export const checkOldDirections = (directions: Direction | Direction[]) => {
    if (typeof directions === "string") {
        return DIRECTIONS_MAP_OLD[directions] || directions;
    }

    return directions;
};

export const getDirections = (
    directions: Direction | Direction[] = NEW_DIRECTIONS
): NewDirection | NewDirection[] => {
    if (typeof directions === "string") {
        return DIRECTIONS_MAP[directions] as NewDirection;
    } else if (Array.isArray(directions)) {
        return directions.map(
            (direction) => DIRECTIONS_MAP[direction]
        ) as NewDirection[];
    }

    return directions;
};

export const withDirections =
    <Props extends IPopupProps & TooltipProps>(
        WrappedComponent: ComponentType<Props>
    ) =>
    (props: Props & { directions: Direction | Direction[] }) => {
        const forwardProps = { ...props };

        forwardProps.direction = getDirections(
            checkOldDirections(props.directions) || props.direction
        );

        return <WrappedComponent {...forwardProps} />;
    };
