export const sameWidthPopperModifier = (options?: { property?: string }) => ({
  name: 'sameWidth',
  enabled: true,
  phase: 'beforeWrite' as const,
  requires: ['computeStyles'],
  fn: ({ state }) => {
    let property = options?.property || 'width';
    state.styles.popper[property] = `${state.rects.reference.width}px`;
  },
  effect: ({ state }) => {
    let property = options?.property || 'width';
    state.elements.popper.style[property] = `${state.elements.reference.offsetWidth}px`;
  },
});
