import express from 'express';
import { addRequestId } from 'middlewares/addRequestId';
import { loadMetricsProvideUrl } from './loaders/loadMetricsProvideUrl';
import { loadHTTPMetrics } from './loaders/loadHTTPMetrics';
import { loadErrorHandlers } from './loaders/loadErrorHandlers';
import { loadLogger } from './loaders/loadLogger';

export function createMetricsApp() {
    const app = express();

    loadLogger(app);
    app.use(addRequestId);
    loadHTTPMetrics(app);
    loadMetricsProvideUrl(app);
    loadErrorHandlers(app);

    return app;
}
