import 'reflect-metadata';
import { createApp } from './createApp';
import { createMetricsApp } from './createMetricsApp';

function startServer() {
    const PORT = process.env.PORT || 80;

    const app = createApp();
    app.disable('x-powered-by');

    app.listen(PORT, () => {
        // eslint-disable-next-line no-console
        console.log(`⚡️[server]: App server is running at http://localhost:${PORT}`);
    });

    createMetricsApp().listen(3456, () => {
        // eslint-disable-next-line no-console
        console.log('⚡️[server]: Metric server is running at http://localhost:3456');
    });
}

startServer();
