import { Application } from 'express';
import { addRequestId } from 'middlewares/addRequestId';
import expressXff from '@yandex-int/express-x-forwarded-for-fix';
import { backendClients } from 'middlewares/backendClients';
import { loadYandexAuth } from './loadYandexAuth';
import { loadIndexHTML } from './loadIndexHTML';
import { loadRoutes } from './loadRoutes';
import { loadCRMBackendProxy } from './loadCRMBackendProxy';
import { loadCSP } from './loadCSP';
import { loadChecks } from './loadChecks';
import { loadHTTPMetrics } from './loadHTTPMetrics';
import { loadMetricsProvideUrl } from './loadMetricsProvideUrl';
import { loadErrorHandlers } from './loadErrorHandlers';
import { loadLogger } from './loadLogger';
import { loadCsrf } from './loadCsrf';
import { loadWfaas } from './loadWfaas';

export const loaders = async(app: Application) => {
    app.enable('trust proxy');
    loadLogger(app);
    app.use(addRequestId);
    app.use(expressXff());
    loadHTTPMetrics(app);
    if (process.env.NODE_ENV === 'development') {
        loadMetricsProvideUrl(app);
    }
    loadChecks(app);
    loadWfaas(app);
    loadYandexAuth(app);
    loadCSP(app);
    loadCsrf(app);
    app.use(backendClients);
    loadIndexHTML();
    loadRoutes(app);
    loadCRMBackendProxy(app);
    loadErrorHandlers(app);
};
