import { Application } from 'express';
import { expressYandexCsp } from '@yandex-int/express-yandex-csp';
import { Config } from 'services/Config';

export const loadCSP = (app: Application) => {
    const config = Config.getInstance();

    app.use(expressYandexCsp({
        directives: {
            'default-src': ["'none'"],
            'script-src': ['%nonce%', "'unsafe-inline'", "'unsafe-eval'", 'mc.yandex.ru', '*.yastatic.net', 'yastatic.net', 'center.yandex-team.ru', 'april.yandex-team.ru', 'test.april.yandex-team.ru', 'chat.s3.yandex.net', '*.s3.mds.yandex.net'],
            'style-src': ["'self'", "'unsafe-inline'", '*.yastatic.net', 'yastatic.net', 'april.yandex-team.ru', 'test.april.yandex-team.ru', '*.s3.mds.yandex.net'],
            'font-src': ["'self'", 'data:', '*.yastatic.net', 'yastatic.net', 'april.yandex-team.ru', 'test.april.yandex-team.ru', '*.s3.mds.yandex.net'],
            'media-src': ["'self'", '*.yastatic.net', 'yastatic.net', '*.s3.mds.yandex.net'],
            'img-src': ["'self'", 'data:', '*.yandex-team.ru', 'center.yandex-team.ru', 'mc.yandex.ru', 'center.yandex-team.ru', '*.yandex.net', '*.yastatic.net', 'yandex.net', 'yastatic.net', '*.s3.mds.yandex.net'],
            'connect-src': ["'self'", 'yandex.ru', 'mc.yandex.by', 'center.yandex-team.ru', 'mc.yandex.ru', 'yastatic.net', 'yandexmetrica.com', 'wss://octopus-stats.paysys.yandex-team.ru:8804', 'wss://octopus-stats-test.paysys.yandex-team.ru:8804', 'https://*.yandex-team.ru', 'wss://schi.yandex-team.ru', 'wss://push.yandex-team.ru', 'wss://infra-sockets.yandex-team.ru'],
            'child-src': ["'self'", '*.yandex-team.ru', '*.yandex.ru', 'wiki.yandex-team.ru', 'docviewer.tst.yandex-team.ru', 'docviewer.yandex-team.ru', 'charts.yandex-team.ru', 'forms.test.yandex-team.ru', 'forms.yandex-team.ru', 'mc.yandex.ru', 'https://yandex.ru', 'https://*.hamster.yandex.ru'],
            'object-src': ["'none'"],
            'worker-src': ["'self'", 'blob:','data:', 'yastatic.net'],
        },
        project: 'crm',
        from: config.pathToStatic,
        useDefaultReportUri: true,
    }));
};
