import { Application } from 'express';
import cors from 'cors';
import { indexHTMLProvider } from 'services/IndexHTMLProvider';

export const loadChecks = (app: Application) => {
    app.get(['/ping', '/healthcheck'], cors(), (req, res) => res.send('OK'));
    app.get('/ready', cors(), (req, res) => res.send(indexHTMLProvider.html ? 'OK' : 'Not OK'));
    app.get('/ping/ip', (req, res) => res.send(req.ip));
};
