import { Request, Response, NextFunction, Application } from 'express';
import createSecretkey from '@yandex-int/express-secretkey';
import { Config } from 'services/Config';

const config = Config.getInstance();

const CSRF_HEADER_KEY = 'x-csrf-token';
const CSRF_COOKIE_KEY = 'x-csrf-token';

const CSRF_COOKIE_KEY_OLD = 'x-csrf-token-frontend';

const getCsrfValue = (req: Request) => req.headers[CSRF_HEADER_KEY];

const secretkey = createSecretkey({ version: 2, salt: config.appKey, value: getCsrfValue });

export const updateCsrf = (req: Request, res: Response, next: NextFunction) => {
    res.cookie(CSRF_COOKIE_KEY, req.secretkey, { encode: v => v });
    res.clearCookie(CSRF_COOKIE_KEY_OLD);

    next();
};

export function loadCsrf(app: Application) {
    app.use(secretkey);
    app.use(updateCsrf);
    app.use(secretkey.validate);
}
