import { Application } from 'express';
import createLogger, { LogLevel, LoggerOptions } from '@yandex-int/yandex-logger';
import presetDefault from '@yandex-int/yandex-logger/middleware/preset-default';
import line from '@yandex-int/yandex-logger/streams/line';
import deploy from '@yandex-int/yandex-logger/streams/deploy';
import createRequestMiddleware from '@yandex-int/yandex-logger/express-middleware/request';
import { Config } from 'services/Config';
import { createKibanaLogStream } from 'utils/createKibanaLogStream';

// eslint-disable-next-line @typescript-eslint/no-explicit-any
const addRequestIdByClient = (record: any) => {
    if (record.req.requestIdByClient) {
        record.requestIdByClient = record.req.requestIdByClient;
    }
};

export const loadLogger = (app: Application) => {
    const appConfig = Config.getInstance();

    const config = {
        name: 'crm-logger',
        streams: process.env.NODE_ENV === 'test' ? [] : [
            {
                level: 'info' as LogLevel,
                stream: (Config.getInstance().loggerMode === Config.LoggerMode.Deploy ? deploy() : line()),
            },
            appConfig.kibanaLogPath && {
                level: 'info' as LogLevel,
                stream: createKibanaLogStream({ path: Config.getInstance().kibanaLogPath }),
            },
        ].filter(Boolean),
        middleware: [
            addRequestIdByClient,
            presetDefault(),
        ],
        fields: {},
    };

    const logger = createLogger(config as unknown as LoggerOptions);
    app.logger = logger;
    app.use(createRequestMiddleware(logger));
};
