import { Application } from 'express';
import { router as routerApi } from 'routes/api';
import { router as routerIndex } from 'routes/index';
import { router as routerAuth } from 'routes/auth';
import { router as routerInfo } from 'routes/info';
import { router as routerCleanup } from 'routes/cleanup';

export const loadRoutes = (app: Application) => {
    app.use(routerIndex);
    app.use(routerAuth);
    app.use(routerInfo);
    app.use(routerCleanup);
    app.get('/whoami', (req, res) => {
        res.json({ login: req.blackbox?.login });
    });
    app.use('/v0', routerApi);
};
