import { Request, Response, NextFunction } from 'express';
import { v4 } from 'uuid';

export const addRequestId = (req: Request, res: Response, next: NextFunction) => {
    req.requestId = v4();

    if (req.query._wid) {
        req.requestIdByClient = String(req.query._wid ?? '');
    }

    next();
};
