import got from 'got';
import { Request, Response, NextFunction } from 'express';

// Middleware используется ТОЛЬКО для dev,
// нужна, чтобы получить внешний IP,
// который в свою очередь, нужен для того,
// чтобы локально можно было ходить в blackbox

export interface DevUserIpMiddlewareOptions {
    url: string;
}

export const devUserIpMiddleware = (options: DevUserIpMiddlewareOptions) =>
    (req: Request, res: Response, next: NextFunction) => {
        got.get(options.url)
            .then(response => {
                req.devUserIp = response.body;
                req.logger.info('success get dev user ip');
                next();
            })
            .catch(next);
    };
