import { Request, Response, NextFunction } from 'express';
import createError from 'http-errors';
import stringify from 'json-stringify-safe';
import { globalRegistry } from '@yandex-data-ui/monlib-nodejs';
import { RequestError } from 'got';
import { ClassValidatorError } from 'models/ClassValidatorError';

export function errorHandler(error: Error, req: Request, res: Response, _next: NextFunction) {
    let extraData: Record<string, unknown> = {};
    if (createError.isHttpError(error)) {
        res.status(error.status);
        extraData = { code: error.code };
    } else if (error instanceof RequestError) {
        res.status(502);
    } else if (error instanceof ClassValidatorError) {
        res.status(400);
        req.logger.warn(error);
    } else {
        globalRegistry.rate('http.server.errors').inc();
        req.logger.error(error);
        res.status(500);
    }

    res.setHeader('Content-Type', 'application/json');
    res.end(stringify({ message: error.message, ...extraData }));
}
