import {
    NextFunction,
    Request,
    RequestHandler,
    Response,
} from 'express';
import { Config } from 'services/Config';
import { globalRegistry } from '@yandex-data-ui/monlib-nodejs';

export const passportRedirect = (): RequestHandler => {
    const config = Config.getInstance();

    return (req: Request, res: Response, next: NextFunction) => {
        globalRegistry.rate('services.blackbox.status', { status: req.blackbox?.status ?? 'unknown' }).inc();

        if (req.blackbox?.status === 'VALID') {
            return next();
        }

        if (req.blackbox?.status === 'NEED_RESET') {
            res.setHeader('x-blackbox-need-reset', 'true');
            return next();
        }

        const blackboxResponse = { ...req.blackbox };
        delete blackboxResponse.raw;
        delete blackboxResponse.userTicket;

        req.logger.warn({ blackboxResponse }, 'blackbox auth');

        const redirectTo = `https://passport.yandex-team.ru/auth?retpath=${config.crmAppUrl}`;

        if (req.xhr) {
            return res.status(401).send({ redirectTo });
        }
        return res.redirect(redirectTo);
    };
};
