import { Request, Response, NextFunction } from 'express';
import ExpressTvmError from '@yandex-int/express-tvm/dist/error';

export const secureTVMError = (error: Error, req: Request, res: Response, next: NextFunction) => {
    if (error instanceof ExpressTvmError && error.originalError) {
        const gotError = error.originalError as (Error & { gotOptions: unknown });

        delete gotError.gotOptions;
    }

    next(error);
};
