import express, { Request } from 'express';
import bunker from '@yandex-int/express-bunker';
import { WithBunker } from 'typings/WithBunker';
import get from 'lodash/get';
import { Config } from 'services/Config';

const bunkerMiddleware = bunker({
    api: Config.getInstance().bunkerApiUrl,
    project: 'crm-space/frontend/',
    version: 'stable',
});

export const router = express.Router();

router.get('/bunker/cat', bunkerMiddleware, (req, res) => {
    const node = (req.query as {node?: string}).node ?? '';

    let data = (req as (Request & WithBunker)).bunker;
    if (node) {
        data = get(data, node.split('/'));
    }

    if (!data) {
        return res.status(404).json({ message: 'No data' });
    }

    res.json(data);
});
