import express, { Request, Response } from 'express';
import asyncHandler from 'express-async-handler';
import { Config } from 'services/Config';
import { SetDelegationData } from 'models/SetDelegationData';
import { validateOrReject } from 'utils/validateOrReject';
import { plainToInstance, instanceToPlain } from 'class-transformer';

export const router = express.Router();

const config = Config.getInstance();

router.post('/auth/login/asdelegated', express.json(), express.urlencoded({ extended: false }), asyncHandler(async(req: Request, res: Response) => {
    const setDelegationData = plainToInstance(
        SetDelegationData,
        req.body,
        { excludeExtraneousValues: true, enableImplicitConversion: true },
    );

    await validateOrReject(setDelegationData);
    await req.backendClients.crm.post('auth/login/asdelegated', { json: instanceToPlain(setDelegationData) });

    res.cookie(config.delegationIdCookieName, setDelegationData.delegationId).end();
}));

router.post('/auth/logout/asdelegated', asyncHandler(async(req: Request, res: Response) => {
    await req.backendClients.crm.post('auth/logout/asdelegated');

    res.clearCookie(config.delegationIdCookieName).end();
}));
